<?php
set_time_limit(0);
date_default_timezone_set('Asia/Tehran');

$BOT_TOKEN = 'YOUR_BOT_TOKEN_HERE'; // جایگزین با توکن ربات
$allowed_chat_id = 123456789;       // جایگزین با Chat ID خودت
$API_URL = "https://api.telegram.org/bot$BOT_TOKEN/";

$dbFile = __DIR__ . '/shop.db';
$pdo = new PDO('sqlite:' . $dbFile);
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// === DB init ===
$pdo->exec("CREATE TABLE IF NOT EXISTS doors (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    name TEXT NOT NULL
)");
$pdo->exec("CREATE TABLE IF NOT EXISTS models (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    door_id INTEGER NOT NULL,
    name TEXT NOT NULL,
    FOREIGN KEY(door_id) REFERENCES doors(id)
)");
$pdo->exec("CREATE TABLE IF NOT EXISTS invoices (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    invoice_no TEXT NOT NULL UNIQUE,
    door_id INTEGER NOT NULL,
    model_id INTEGER NOT NULL,
    width INTEGER NOT NULL,
    customer TEXT,
    phone TEXT,
    amount REAL NOT NULL,
    delivered INTEGER DEFAULT 0,
    created_at TEXT NOT NULL
)");

// === Telegram helpers ===
function tg_request($method, $params = []) {
    global $API_URL;
    $ch = curl_init($API_URL . $method);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => $params
    ]);
    $res = curl_exec($ch);
    curl_close($ch);
    return json_decode($res, true);
}

function sendMessage($chat_id, $text, $keyboard = null) {
    $params = ['chat_id' => $chat_id, 'text' => $text, 'parse_mode' => 'HTML'];
    if ($keyboard) $params['reply_markup'] = json_encode($keyboard, JSON_UNESCAPED_UNICODE);
    return tg_request('sendMessage', $params);
}

function sendInlineKeyboard($chat_id, $text, $keyboard) {
    return sendMessage($chat_id, $text, ['inline_keyboard' => $keyboard]);
}

function answerCB($id, $text='') { tg_request('answerCallbackQuery',['callback_query_id'=>$id,'text'=>$text]); }

// === Jalali date ===
function gregorian_to_jalali($gy,$gm,$gd){
    $g_d_m = [0,31,59,90,120,151,181,212,243,273,304,334];
    $gy2 = ($gm>2)?($gy+1):$gy;
    $days = 355666 + (365*$gy) + floor(($gy2+3)/4) - floor(($gy2+99)/100) + floor(($gy2+399)/400) + $gd + $g_d_m[$gm-1];
    $jy = -1595 + (33*floor($days/12053));
    $days %= 12053;
    $jy += 4*floor($days/1461);
    $days %= 1461;
    if($days > 365){
        $jy += floor(($days-1)/365);
        $days = ($days-1)%365;
    }
    $jm = ($days < 186)?1+floor($days/31):7+floor(($days-186)/30);
    $jd = 1 + (($days < 186)?($days%31):(($days-186)%30));
    return [$jy,$jm,$jd];
}
function toJalali($timestamp){
    [$y,$m,$d] = explode('-', date('Y-m-d', strtotime($timestamp)));
    [$jy,$jm,$jd] = gregorian_to_jalali($y,$m,$d);
    return sprintf("%04d/%02d/%02d",$jy,$jm,$jd);
}

// === Invoice number ===
function gen_invoice_no($pdo){
    $day = date('Ymd');
    $r = $pdo->prepare("SELECT COUNT(*) as cnt FROM invoices WHERE created_at LIKE ?");
    $r->execute([$day.'%']);
    $row = $r->fetch();
    $c = ($row['cnt'] ?? 0) + 1;
    return sprintf("%s-%04d",$day,$c);
}

// === Keyboards ===
function mainMenu() {
    return ['keyboard'=>[
        ['➕ افزودن نوع درب جدید'],
        ['💰 فروش درب'],
        ['📋 فاکتورهای کلی']
    ], 'resize_keyboard'=>true];
}

function backMenu() {
    return ['inline_keyboard'=>[[['text'=>'🔙 بازگشت به منوی اصلی','callback_data'=>'main_menu']]]];
}

// === Handle Updates ===
$offset = 0;
while(true){
    $res = tg_request('getUpdates',['timeout'=>30,'offset'=>$offset+1]);
    if(!$res || !isset($res['result'])) continue;
    foreach($res['result'] as $u){
        $offset = $u['update_id'];

        // Message
        if(isset($u['message'])){
            $m = $u['message']; 
            $chat_id = $m['chat']['id']; 
            $text = $m['text'] ?? '';

            // === محدودیت فقط برای تو ===
            global $allowed_chat_id;
            if($chat_id != $allowed_chat_id){
                tg_request('sendMessage',['chat_id'=>$chat_id,'text'=>'🚫 دسترسی غیرمجاز']);
                continue;
            }

            if(in_array($text,['/start','منو اصلی'])){
                sendMessage($chat_id,"📍 منوی اصلی ربات مدیریت فروش درب:",mainMenu());
                continue;
            }

            // ادامه کد برای افزودن نوع درب، فروش، فاکتور ...
            // این قسمت مثل نسخه قبل ادامه پیدا می‌کنه، با همان مراحل مرحله‌ای و دکمه‌ها
        }

        // Callback queries
        if(isset($u['callback_query'])){
            $cb = $u['callback_query']; 
            $chat_id = $cb['message']['chat']['id']; 
            $data = $cb['data'];
            answerCB($cb['id']);

            // محدودیت فقط برای تو
            if($chat_id != $allowed_chat_id){
                tg_request('sendMessage',['chat_id'=>$chat_id,'text'=>'🚫 دسترسی غیرمجاز']);
                continue;
            }

            if($data=='main_menu'){
                sendMessage($chat_id,"📍 منوی اصلی:",mainMenu());
                continue;
            }

            // ادامه کد Callback ها برای انتخاب مدل، وضعیت تحویل، PDF...
        }
    }
}
?>